/*  */
/*     HAMEG GmbH                                                          */
/*     Sample program for Interface HO79                                   */
/*     Communication with HAMEG scope;            Command : "GET"          */
/*  */

#include <dos.h>
#include <bios.h>
#include <stdio.h>
#include <mc.h>
#include <param.h>
#include <ho79data.h>
/*  */
int main (int, char * []);
/*  */

int					io_adr = 0x2B8;
struct param_set	get_param_set = {
	"GET - Demo program for HO79 + HO80 (IEEE transfer) ",   "GET dev=b",
	{ {"dev", "device"},
	  {"seg", "segment"},
	  {"", ""}, {"", ""}, {"", ""}, {"", ""},
	  {"", ""}, {"", ""}, {"", ""}, {"", ""}  }
};
/*  */
/*                                m a i n                                  */
/*  */
int main (argc, argv)
int		argc;
char	*argv[];
{
int 	ieee_chef, my_address;
int     status, pol, anz, pos;

	seg = 0xc000;
	if ( (param (argc, argv, &get_param_set) !=0) || (argc<=1))
		return(1);
	HO80_SEG = seg;
	if (ieee_se(HO80_SEG) != 0) {
		printf ("HO80 IEEE-488 not found");
		return (2);
	}
	ieee_chef = 0;                           /*  IEEE-488 controller   */
	my_address = 21;                        /*  "my" device address  */
	init (&ieee_chef,&my_address);      /*  Initialisation of HO80 card  */
	delay (3000);               /* Wait until initialisation terminated! */
	iwd (&status, "FRM 0", &dev);			/* set binary format */
	iwd (&status, "GET", &dev);
	while ((inport(io_adr+2)&0x40)==0x00);
	ispl (&status, &pol, &dev);
	anz=ho79_data(dev);
	printf (" \n %d bytes received", anz);
	bioskey (0);
	for (pos=0; pos <anz; pos++) {
		if (pos%0x10==0) printf ("\n %4X   ", pos);
		printf (" %2X", data[pos]);
	}
	return(0);
}
